/*
 * Decompiled with CFR 0.152.
 */
package mod_cfml;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.servlet.ServletException;
import org.apache.catalina.Container;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.startup.HostConfig;
import org.apache.catalina.valves.ValveBase;

public class core
extends ValveBase
implements Serializable {
    private String tcDocRoot;
    private String tcHost;
    private String[] tcHostPortFilter;
    private String[] contextRecord;
    private String tcURI;
    private String tcURIParams;
    private String tcRedirectURL;
    private String newHostConfDir;
    private String newHostWorkDir;
    private boolean loggingEnabled = false;
    private int waitForContext = 3;
    private int timeBetweenContexts = 30000;
    private int maxContexts = 10;

    public boolean getLoggingEnabled() {
        return this.loggingEnabled;
    }

    public void setLoggingEnabled(boolean loggingEnabled) {
        this.loggingEnabled = loggingEnabled;
    }

    public int getWaitForContext() {
        return this.waitForContext;
    }

    public void setWaitForContext(int waitForContext) {
        this.waitForContext = waitForContext;
    }

    public int getTimeBetweenContexts() {
        return this.timeBetweenContexts;
    }

    public void setTimeBetweenContexts(int timeBetweenContexts) {
        this.timeBetweenContexts = timeBetweenContexts;
    }

    public int getMaxContexts() {
        return this.maxContexts;
    }

    public void setMaxContexts(int maxContexts) {
        this.maxContexts = maxContexts;
    }

    public void invoke(Request request, Response response) throws IOException, ServletException {
        SimpleDateFormat dayInYear;
        Date newNow;
        Engine engine;
        block47: {
            if (this.waitForContext < 0) {
                this.waitForContext = 3;
            }
            this.tcDocRoot = request.getHeader("X-Tomcat-DocRoot");
            this.tcHost = request.getHeader("Host");
            this.tcURI = request.getDecodedRequestURI();
            this.tcURIParams = request.getQueryString();
            if (this.tcHost == null || this.tcHost.length() == 0) {
                if (this.loggingEnabled) {
                    System.out.println("[mod_cfml] FATAL: Invalid host: Null or zero-length.");
                }
                this.getNext().invoke(request, response);
                return;
            }
            if (this.loggingEnabled) {
                System.out.println("[mod_cfml] Decoded Requst URI => " + this.tcURI);
                System.out.println("[mod_cfml] QueryString => " + this.tcURIParams);
                System.out.println("[mod_cfml] DocRoot Value => " + this.tcDocRoot);
                System.out.println("[mod_cfml] Host Value => " + this.tcHost);
            }
            Host currentHost = (Host)this.getContainer();
            engine = (Engine)currentHost.getParent();
            if (this.tcDocRoot == null || this.tcDocRoot.length() == 0) {
                if (this.loggingEnabled) {
                    System.out.println("[mod_cfml] FATAL: Invalid DocRoot: Null or zero-length.");
                }
                this.getNext().invoke(request, response);
                return;
            }
            if (this.loggingEnabled) {
                System.out.println("[mod_cfml] tcHost contains ':' ? => " + this.tcHost.contains(":"));
            }
            if (this.tcHost.contains(":")) {
                this.tcHostPortFilter = this.tcHost.split(":");
                if (this.loggingEnabled) {
                    for (int i = 0; i < this.tcHostPortFilter.length; ++i) {
                        System.out.println("[mod_cfml] Host split value [" + i + "]: " + this.tcHostPortFilter[i]);
                    }
                }
                this.tcHost = this.tcHostPortFilter[0];
            }
            if (engine.findChild(this.tcHost) != null) {
                if (this.loggingEnabled) {
                    System.out.println("[mod_cfml] FATAL: Host already exists.");
                }
                this.getNext().invoke(request, response);
                return;
            }
            newNow = new Date();
            try {
                ObjectInputStream is = new ObjectInputStream(new FileInputStream("mod_cfml.dat"));
                this.contextRecord = (String[])is.readObject();
                if (this.loggingEnabled) {
                    System.out.println("[mod_cfml] lastContext = " + this.contextRecord[0]);
                    System.out.println("[mod_cfml] throttleDate = " + this.contextRecord[1]);
                    System.out.println("[mod_cfml] throttleValue = " + this.contextRecord[2]);
                }
            }
            catch (Exception ex) {
                if (!this.loggingEnabled) break block47;
                System.out.println("[mod_cfml] Serialization Read Exception: " + ex.toString());
            }
        }
        if (this.contextRecord == null || this.contextRecord.length == 0) {
            this.contextRecord = new String[3];
            this.contextRecord[0] = null;
            dayInYear = new SimpleDateFormat("D");
            this.contextRecord[1] = dayInYear.format(newNow);
            this.contextRecord[2] = "0";
            if (this.loggingEnabled) {
                System.out.println("[mod_cfml] New contextRecord Array initialized...");
                System.out.println("[mod_cfml] lastContext = " + this.contextRecord[0]);
                System.out.println("[mod_cfml] throttleDate = " + this.contextRecord[1]);
                System.out.println("[mod_cfml] throttleValue = " + this.contextRecord[2]);
            }
        }
        dayInYear = new SimpleDateFormat("D");
        if (Integer.parseInt(this.contextRecord[1]) != Integer.parseInt(dayInYear.format(newNow))) {
            if (this.loggingEnabled) {
                System.out.println("[mod_cfml] New day detected. Reinitializing throttleDate and throttleValue.");
            }
            this.contextRecord[1] = dayInYear.format(newNow);
            this.contextRecord[2] = "0";
        }
        if (this.contextRecord[0] != null && Long.parseLong(this.contextRecord[0]) + (long)this.timeBetweenContexts > newNow.getTime()) {
            System.out.println("[mod_cfml] Time Between Contexts has not been fulfilled. Please wait a few moments and try again.");
            response.sendError(503, "[mod_cfml] Time Between Contexts has not been fulfilled. Please wait a few moments and try again.");
            return;
        }
        if (Integer.parseInt(this.contextRecord[2]) >= this.maxContexts) {
            System.out.println("[mod_cfml] MaxContexts limit reached. Try again tomorrow.");
            response.sendError(503, "[mod_cfml] MaxContexts limit reached. Try again tomorrow.");
            return;
        }
        File tcDocRootFile = null;
        File file = null;
        file = new File(this.tcDocRoot);
        tcDocRootFile = file.getCanonicalFile();
        if (tcDocRootFile.isDirectory()) {
            block48: {
                this.newHostConfDir = System.getProperty("catalina.base") + "/conf/Catalina/" + this.tcHost;
                File newHostConfDirFile = null;
                file = new File(this.newHostConfDir);
                newHostConfDirFile = file.getCanonicalFile();
                if (!newHostConfDirFile.isDirectory()) {
                    if (this.loggingEnabled) {
                        System.out.println("[mod_cfml] Creating new config directory: " + newHostConfDirFile);
                    }
                    file.mkdir();
                } else {
                    if (this.loggingEnabled) {
                        System.out.println("[mod_cfml] Removing old config directory: " + newHostConfDirFile);
                    }
                    core.deleteDir(file);
                    if (this.loggingEnabled) {
                        System.out.println("[mod_cfml] Creating new config directory: " + newHostConfDirFile);
                    }
                    file.mkdir();
                }
                this.newHostWorkDir = System.getProperty("catalina.base") + "/work/Catalina/" + this.tcHost;
                File newHostWorkDirFile = null;
                file = new File(this.newHostWorkDir);
                newHostWorkDirFile = file.getCanonicalFile();
                if (!newHostConfDirFile.isDirectory()) {
                    if (this.loggingEnabled) {
                        System.out.println("[mod_cfml] Work directory doesn't exist: " + newHostWorkDirFile);
                    }
                } else {
                    if (this.loggingEnabled) {
                        System.out.println("[mod_cfml] Removing old work directory: " + newHostWorkDirFile);
                    }
                    core.deleteDir(file);
                }
                String newHostConfFile = newHostConfDirFile + "/ROOT.xml";
                if (this.loggingEnabled) {
                    System.out.println("[mod_cfml] Creating context file: " + newHostConfFile);
                }
                PrintWriter out = new PrintWriter(new FileOutputStream(newHostConfFile));
                out.println("<?xml version='1.0' encoding='utf-8'?>");
                out.println("<Context docBase=\"" + this.tcDocRoot + "\">");
                out.println("  <WatchedResource>WEB-INF/web.xml</WatchedResource>");
                out.println("</Context>");
                out.flush();
                out.close();
                if (this.loggingEnabled) {
                    System.out.println("[mod_cfml] Wait for context? => " + (this.waitForContext > 0));
                }
                if (this.waitForContext > 0) {
                    if (this.loggingEnabled) {
                        System.out.println("[mod_cfml] Verifying context files...");
                    }
                    File tcContextXMLFile = null;
                    File tcContextXMLFilePointer = null;
                    tcContextXMLFilePointer = new File(newHostConfFile);
                    tcContextXMLFile = tcContextXMLFilePointer.getCanonicalFile();
                    for (int i = 0; !(i >= this.waitForContext || newHostConfDirFile.isDirectory() && tcContextXMLFile.isFile() && newHostWorkDirFile.isDirectory()); ++i) {
                        if (this.loggingEnabled) {
                            System.out.println("[mod_cfml] Waiting for context files: [" + i + "]");
                        }
                        try {
                            Thread.sleep(1000L);
                            continue;
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                    }
                    if (this.loggingEnabled) {
                        System.out.println("[mod_cfml] Wait loop ended. Context files found? [" + tcContextXMLFile.isFile() + "]");
                    }
                }
                StandardHost host = new StandardHost();
                if (this.loggingEnabled) {
                    System.out.println("[mod_cfml] Creating New Host... ");
                    System.out.println("[mod_cfml] setName Value => " + this.tcHost);
                }
                host.addLifecycleListener((LifecycleListener)new HostConfig());
                host.setAppBase("webapps");
                host.setName(this.tcHost);
                host.setAutoDeploy(true);
                host.setDeployOnStartup(true);
                host.setDeployXML(true);
                try {
                    engine.addChild((Container)host);
                }
                catch (Exception e) {
                    System.out.println(e.toString());
                    return;
                }
                this.contextRecord[0] = String.valueOf(newNow.getTime());
                int numContexts = Integer.parseInt(this.contextRecord[2]);
                this.contextRecord[2] = Integer.toString(++numContexts);
                try {
                    ObjectOutputStream os = new ObjectOutputStream(new FileOutputStream("mod_cfml.dat"));
                    os.writeObject(this.contextRecord);
                }
                catch (Exception ex) {
                    if (!this.loggingEnabled) break block48;
                    System.out.println("[mod_cfml] NOTICE: Serialization Write Exception: " + ex.toString());
                }
            }
            this.tcRedirectURL = this.tcURIParams != null && this.tcURIParams.length() > 0 ? this.tcURI + "?" + this.tcURIParams : (this.tcURI.equals("index.cfm") || this.tcURI.equals("/index.cfm") ? "" : this.tcURI);
            if (this.loggingEnabled) {
                System.out.println("[mod_cfml] Rredirect URL => '" + this.tcRedirectURL + "'");
            }
            response.sendRedirect(this.tcRedirectURL);
            return;
        }
        if (this.loggingEnabled) {
            System.out.println("[mod_cfml] FATAL: DocRoot value failed isDirectory() check. Directory may not exist, or Tomcat may not have permission to check it.");
        }
        this.getNext().invoke(request, response);
    }

    public static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = core.deleteDir(new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }
}

