/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.mail.activation;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import javax.activation.DataSource;
import javax.activation.FileTypeMap;

public final class PathDataSource
implements DataSource {
    private final Path path;
    private final FileTypeMap typeMap;
    private final OpenOption[] options;

    public PathDataSource(Path path) {
        this(path, FileTypeMap.getDefaultFileTypeMap(), new OpenOption[0]);
    }

    public PathDataSource(Path path, FileTypeMap typeMap, OpenOption ... options) {
        this.path = Objects.requireNonNull(path, "path");
        this.typeMap = Objects.requireNonNull(typeMap, "typeMap");
        this.options = options;
    }

    @Override
    public String getContentType() {
        return this.typeMap.getContentType(this.getName());
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return Files.newInputStream(this.path, this.options);
    }

    @Override
    public String getName() {
        return Objects.toString(this.path.getFileName(), null);
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return Files.newOutputStream(this.path, this.options);
    }

    public Path getPath() {
        return this.path;
    }
}

