#!/bin/sh
#  memory settings
# -Xms<size> set initial Java heap size
# -Xmx<size> set maximum Java heap size
# -Xss<size> set java thread stack size
# -XX:MaxPermSize sets the java PermGen size
#SETENV_DIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )" && pwd )"
#SETENV_PARENT_DIR="$(cd $SETENV_DIR/../../; pwd)"
SETENV_DIR="$( cd "$( dirname "$0" )" && pwd )"
SETENV_PARENT_DIR="$(cd $SETENV_DIR/../../; pwd)"

JAVA_OPTS="$JAVA_OPTS -Xms128m -Xmx256m -XX:MaxPermSize=64m";  # memory settings
JAVA_AGENT_REL="../../lib-lucee/lucee-inst.jar";
JRE_HOME_REL="NOJRE";
if [ ! -z "$JAVA_AGENT_REL" ] ; then
  JAVA_OPTS="$JAVA_OPTS -javaagent:$SETENV_DIR/../../lib-lucee/lucee-inst.jar ";   # java agent settings
fi
if [ ! -z "$JRE_HOME_REL" ] ; then
  if [ -d "$SETENV_PARENT_DIR/NOJRE" ] ; then
    JRE_HOME=$SETENV_PARENT_DIR/NOJRE
    JAVA_HOME=$SETENV_PARENT_DIR/NOJRE
    export JRE_HOME;
    export JAVA_HOME;
    echo "SET JAVA_HOME to $JAVA_HOME"
  fi
fi
if [ -z "$JAVA_HOME" ] ; then
  for jre in "$SETENV_PARENT_DIR/jre" "$SETENV_PARENT_DIR/../jre" "$SETENV_PARENT_DIR/../../jre"
  do
  if [ -d "$jre" ] ; then
    JRE_HOME=$jre
    JAVA_HOME=$jre
    export JRE_HOME;
    export JAVA_HOME;
    echo "SET JAVA_HOME to $JAVA_HOME"
  fi
  done
fi

# needed by FR
# LD_LIBRARY_PATH=${LD_LIBRARY_PATH}:/opt/lucee/fusionreactor/etc/lib

export JAVA_OPTS;
